<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>HiPex 2025 해운대 - Hospital Innovation and Patient Experience Conference</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Malgun Gothic', -apple-system, BlinkMacSystemFont, sans-serif;
            line-height: 1.6;
            color: #333;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }

        /* 헤더 */
        .header {
            background: #fff;
            padding: 20px 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .header-content {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 20px;
        }

        .logo img {
            max-width: 200px;
            height: auto;
        }

        .header-info {
            display: flex;
            flex-direction: column;
            gap: 10px;
            text-align: center;
        }

        .info-item {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            font-size: 14px;
        }

        .info-item img {
            width: 16px;
            height: 16px;
        }

        /* 슬라이더 */
        .slider {
            position: relative;
            overflow: hidden;
            height: 300px;
            background: #f5f5f5;
        }

        .slider img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        /* 네비게이션 */
        .nav {
            background: #151314;
            padding: 0;
        }

        .nav-menu {
            display: flex;
            list-style: none;
            margin: 0;
            padding: 0;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }

        .nav-menu li {
            flex-shrink: 0;
        }

        .nav-menu a {
            display: block;
            color: #fff;
            text-decoration: none;
            padding: 18px 20px;
            white-space: nowrap;
            transition: background 0.3s;
        }

        .nav-menu a:hover {
            background: rgba(255,255,255,0.1);
        }

        .nav-menu .register-btn {
            background: #e6001f;
        }

        .nav-menu .register-btn:hover {
            background: #cc001a;
        }

        /* 메인 콘텐츠 */
        .main-content {
            padding: 40px 0;
        }

        .intro-text {
            font-size: 16px;
            line-height: 1.8;
            margin-bottom: 30px;
            text-align: justify;
        }

        .highlight {
            color: #ed1c24;
            font-weight: bold;
            font-size: 18px;
        }

        .conference-title {
            font-size: 20px;
            font-weight: bold;
            margin-bottom: 10px;
        }

        .conference-subtitle {
            font-size: 12px;
            color: #666;
            margin-bottom: 20px;
        }

        /* 배너 */
        .banner {
            text-align: center;
            margin: 40px 0;
        }

        .banner img {
            max-width: 100%;
            height: auto;
        }

        .divider {
            height: 1px;
            background: #e9e9e9;
            margin: 40px 0;
        }

        /* 환자 경험 섹션 */
        .experience-section {
            display: grid;
            grid-template-columns: 1fr;
            gap: 30px;
            margin: 40px 0;
        }

        .experience-text {
            order: 1;
        }

        .experience-image {
            order: 2;
            text-align: center;
        }

        .experience-image img {
            max-width: 100%;
            height: auto;
            max-width: 400px;
        }

        .experience-definition {
            background: #f8f8f8;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }

        .definition-title {
            font-weight: bold;
            margin-bottom: 10px;
        }

        .definition-title .letter-highlight {
            background: #000;
            color: #fff;
            padding: 2px 6px;
            font-size: 18px;
        }

        .quote-author {
            font-size: 14px;
            color: #666;
            margin-top: 10px;
            display: block;
        }

        /* 기사 섹션 */
        .articles-section {
            margin: 40px 0;
        }

        .articles-header {
            display: flex;
            flex-direction: column;
            gap: 10px;
            margin-bottom: 20px;
        }

        .articles-title {
            font-size: 23px;
            font-weight: bold;
            letter-spacing: -1px;
        }

        .hipex-select {
            padding: 8px 12px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
        }

        .articles-divider {
            height: 3px;
            background: #000;
            margin: 10px 0 20px 0;
        }

        .articles-list {
            list-style: none;
        }

        .articles-list li {
            margin-bottom: 15px;
            padding-left: 20px;
            position: relative;
        }

        .articles-list li:before {
            content: "•";
            position: absolute;
            left: 0;
            color: #ed1c24;
            font-weight: bold;
        }

        .articles-list a {
            color: #333;
            text-decoration: none;
            line-height: 1.5;
        }

        .articles-list a:hover {
            color: #ed1c24;
        }

        /* 등록 버튼 */
        .register-section {
            background: #000;
            text-align: center;
            padding: 40px 0;
        }

        .register-btn-large {
            display: inline-block;
            transition: transform 0.3s;
        }

        .register-btn-large:hover {
            transform: scale(1.05);
        }

        .register-btn-large img {
            max-width: 100%;
            height: auto;
        }

        /* 푸터 */
        .footer {
            border-top: 1px solid #000;
            padding: 20px 0;
        }

        .footer-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 20px;
        }

        .footer-logo img {
            max-width: 200px;
            height: auto;
        }

        .social-links {
            display: flex;
            gap: 15px;
        }

        .social-links a {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background: #3b5998;
            color: #fff;
            border-radius: 50%;
            text-decoration: none;
            transition: transform 0.3s;
        }

        .social-links a:hover {
            transform: scale(1.1);
        }

        .social-links a.twitter {
            background: #1da1f2;
        }

        /* 반응형 디자인 */
        @media (min-width: 768px) {
            .header-content {
                flex-direction: row;
                justify-content: space-between;
            }

            .header-info {
                align-items: flex-end;
                text-align: right;
            }

            .slider {
                height: 400px;
            }

            .nav-menu {
                justify-content: center;
            }

            .experience-section {
                grid-template-columns: 1fr auto;
                align-items: start;
            }

            .experience-text {
                order: 1;
            }

            .experience-image {
                order: 2;
            }

            .articles-header {
                flex-direction: row;
                align-items: center;
            }

            .footer-content {
                justify-content: space-between;
            }
        }

        @media (min-width: 1024px) {
            .slider {
                height: 500px;
            }

            .main-content {
                padding: 60px 0;
            }

            .intro-text {
                font-size: 18px;
            }
        }

        /* 모바일 최적화 */
        @media (max-width: 767px) {
            .container {
                padding: 0 15px;
            }

            .logo img {
                max-width: 150px;
            }

            .info-item {
                font-size: 12px;
                flex-direction: column;
                text-align: center;
            }

            .nav-menu {
                padding: 0 15px;
            }

            .nav-menu a {
                padding: 15px;
                font-size: 14px;
            }

            .intro-text {
                font-size: 14px;
            }

            .conference-title {
                font-size: 18px;
            }

            .experience-definition {
                padding: 15px;
            }

            .articles-title {
                font-size: 20px;
            }

            .footer-content {
                flex-direction: column;
                text-align: center;
            }
        }
    </style>
</head>
<body>
    <!-- 헤더 -->
    <header class="header">
        <div class="container">
            <div class="header-content">
                <div class="logo">
                    <a href="http://www.hipex.org/">
                        <img src="http://www.hipex.org/images/2025/logo.png" alt="HiPex 2025 로고">
                    </a>
                </div>
                <div class="header-info">
                    <div class="info-item">
                        <img src="http://www.hipex.org/images/ico_place.png" alt="장소">
                        <a href="https://naver.me/GI3JY3iy" target="_blank">인제대학교 해운대백병원(부산 해운대구 해운대로 875)</a>
                    </div>
                    <div class="info-item">
                        <img src="http://www.hipex.org/images/ico_date.png" alt="날짜">
                        <span>2025.11.13(목)~11.14(금)</span>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- 슬라이더 -->
    <section class="slider">
        <img src="http://www.hipex.org/images/2025b/top_1.png" alt="HiPex 2025 메인 배너">
    </section>

    <!-- 네비게이션 -->
    <nav class="nav">
        <div class="container">
            <ul class="nav-menu">
                <li><a href="http://www.hipex.org/">HiPex 2025 해운대 개요</a></li>
                <li><a href="http://hipex.org/schedule.php">프로그램</a></li>
                <li><a href="http://hipex.org/speaker.php">연자소개</a></li>
                <li><a href="http://hipex.org/regist.php" class="register-btn">사전등록</a></li>
            </ul>
        </div>
    </nav>

    <!-- 메인 콘텐츠 -->
    <main class="main-content">
        <div class="container">
            <!-- 소개 텍스트 -->
            <div class="intro-text">
                <p>최근 세계적으로 보건의료 분야에서 가장 각광받는 주제들 중에는 <span class="highlight">'환자 경험'</span>, 그리고 <span class="highlight">'서비스 디자인'</span>이 있다.</p>
                <p>과거에는 흔히 '고객 만족'이나'질 향상'을 논했으나, 모두 공급자 중심의 접근이라는 한계를 극복하지 못했던 것이 사실이다.</p>
                <p>따라서 최근에는 환자가 실제로 느끼는 불편, 불안, 고통에 더욱 집중함으로써 보건의료 서비스의 진정한 개혁을 도모하려는 움직임이 나타나고 있는 것이다.</p>
            </div>

            <div class="intro-text">
                <div class="conference-title">HiPex 2025 해운대 컨퍼런스</div>
                <div class="conference-subtitle">(<strong>H</strong>ospital <strong>I</strong>nnovation and <strong>P</strong>atient <strong>Ex</strong>perience Conference 2025 Haeundae)</div>
                <p>환자 경험과 서비스 디자인이라는 화두를 통해 이 시대에 필요한 진정한 병원 혁신이란 어떤 모습이어야 하는지를 살펴보는 행사다.</p>
                <p>이번 컨퍼런스에서는 환자 경험과 서비스 디자인 개념을 통한 병원 혁신에 관한 국내 최고의 전문가들이 자신의 경험을 참가자들과 공유할 예정이다.</p>
            </div>

            <!-- 배너 -->
            <div class="banner">
                <img src="https://www.koreahealthlog.com/bannerpop/uploads/image/1714453926998891304.gif" alt="배너">
            </div>

            <div class="divider"></div>

            <!-- 환자 경험 섹션 -->
            <div class="experience-section">
                <div class="experience-text">
                    <div class="experience-definition">
                        <div class="definition-title">
                            <span class="letter-highlight">환</span>자의 경험이란
                        </div>
                        <p>치료의 전 과정에 걸쳐서 환자가 느끼게 되는 감정에 영향을 주는 모든 상호작용의 총합으로, 이는 <span class="highlight">의료기관이라는 조직의 문화에 의해 형성</span>된다.</p>
                        <span class="quote-author">- 베릴 연구소 -</span>
                    </div>

                    <div class="experience-definition">
                        <div class="definition-title">
                            <span class="letter-highlight">환</span>자의 경험이란,
                        </div>
                        <p><span class="highlight">당신이 병원에서 돌아온 다음 배우자에게 들려주는 이야기</span>다.</p>
                        <p>어느 환자도 수술을 받고 나서 "내가 본 것 중에서 최고의 봉합 솜씨였어!"라거나 "여보, 그들이 내 콩팥을 정확히 절제했어요!"라고 말하지는 않는다.</p>
                        <p>그 대신, 우리는 치료의 모든 과정에 참여하여 우리를 돌봐준 모든 사람들, 접수 담당자들, 간호사들, 그리고 의사들에 관해서 이야기한다.</p>
                        <span class="quote-author">- 폴 스피겔만 & 브릿 베렛 -</span>
                    </div>
                </div>
                <div class="experience-image">
                    <img src="http://www.hipex.org/images/img_txt.png" alt="환자 경험 이미지">
                </div>
            </div>

            <!-- 관련 기사 섹션 -->
            <section class="articles-section">
                <div class="articles-header">
                    <h2 class="articles-title">HiPex 2025 관련기사</h2>
                    <select class="hipex-select">
                        <option value="">지난 HiPex보기</option>
                        <option value="2025">HiPex 2025</option>
                        <option value="2024">HiPex 2024</option>
                        <option value="2023">HiPex 2023</option>
                        <option value="2022">HiPex 2022</option>
                        <option value="2019">HiPex 2019</option>
                        <option value="2018">HiPex 2018</option>
                        <option value="2017">HiPex 2017</option>
                        <option value="2016">HiPex 2016</option>
                        <option value="2015">HiPex 2015</option>
                        <option value="2014">HiPex 2014</option>
                    </select>
                </div>
                <div class="articles-divider"></div>
                <ul class="articles-list">
                    <li><a href="http://www.docdocdoc.co.kr/news/articleView.html?idxno=3029411" target="_blank">56위→ 9위…"아주 작고 깜찍하게" 시작한 해운대백병원의 도약</a></li>
                    <li><a href="http://www.docdocdoc.co.kr/news/articleView.html?idxno=3029402" target="_blank">EMR 연동 안되는 DTx…개방형 플랫폼으로 처방 걸림돌 해소</a></li>
                    <li><a href="http://www.docdocdoc.co.kr/news/articleView.html?idxno=3029380" target="_blank">의사·환자 치료법 함께 찾는 '공유의사결정', 한국도 가능할까</a></li>
                    <li><a href="http://www.docdocdoc.co.kr/news/articleView.html?idxno=3029368" target="_blank">진단·치료 한계 여전한 AI…병원은 어디에 활용해야 할까</a></li>
                    <li><a href="http://www.docdocdoc.co.kr/news/articleView.html?idxno=3029345" target="_blank">주치의 말보다 유튜브서 위안 찾는 환자들…환자경험이 위험하다</a></li>
                    <li><a href="http://www.docdocdoc.co.kr/news/articleView.html?idxno=3029329" target="_blank">'모바일·현장·진심·로봇' 병원 혁신의 길을 찾는 다양한 방법</a></li>
                    <li><a href="http://www.docdocdoc.co.kr/news/articleView.html?idxno=3029201" target="_blank">K팝의 새로운 파도 '빅오션'이 말하는 환자경험과 혁신</a></li>
                </ul>
            </section>
        </div>
    </main>

    <!-- 등록 섹션 -->
    <section class="register-section">
        <a href="http://www.hipex.org/regist.php" class="register-btn-large">
            <img src="http://www.hipex.org/images/2025b/img_last.png" alt="사전등록하기">
        </a>
    </section>

    <!-- 푸터 -->
    <footer class="footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-logo">
                    <img src="http://www.hipex.org/images/2025/newlogofooter.png" alt="HiPex 로고">
                </div>
                <div class="social-links">
                    <a href="http://www.facebook.com/sharer/sharer.php?u=http%3A%2F%2Fwww.hipex.org%2F&title=HiPex+2025" target="_blank" class="facebook">
                        <i class="fab fa-facebook-f"></i>
                    </a>
                    <a href="https://twitter.com/intent/tweet?url=http%3A%2F%2Fwww.hipex.org%2F&text=HiPex+2025" target="_blank" class="twitter">
                        <i class="fab fa-twitter"></i>
                    </a>
                </div>
            </div>
        </div>
    </footer>

    <script>
        // 간단한 슬라이더 기능 (필요시 확장 가능)
        const images = [
            'http://www.hipex.org/images/2025b/top_1.png',
            'http://www.hipex.org/images/2025b/top_2.png',
            'http://www.hipex.org/images/2025b/top_3.png',
            'http://www.hipex.org/images/2025b/top_4.png'
        ];

        let currentImageIndex = 0;
        const sliderImg = document.querySelector('.slider img');

        function changeSlide() {
            currentImageIndex = (currentImageIndex + 1) % images.length;
            sliderImg.src = images[currentImageIndex];
        }

        // 5초마다 이미지 변경
        setInterval(changeSlide, 5000);

        // HiPex 선택 기능
        document.querySelector('.hipex-select').addEventListener('change', function() {
            const year = this.value;
            if (year) {
                // 실제 구현시 해당 연도의 페이지로 이동
                console.log(`HiPex ${year} 페이지로 이동`);
            }
        });
    </script>
</body>
</html>