<?php
class DB {
	var $db = "";
	var $ip = "";
	var $id = "www_user";
	var $pw = "doc26460852";

	var $linkID = 0;
	var $queryID = 0;
	var $record = array();
	var $row;

	var $errno = 0;
	var $error = "";
	var $debugAddr = "";

	public function __construct($db = '', $ip = "cms.docdocdoc.kr") {
		$this->db = $db;
		$this->ip = $ip;
	}

	private function connect() {
		if (!$this->linkID) {
			$this->linkID = mysqli_connect($this->ip, $this->id, $this->pw, $this->db);

			if (!$this->linkID) {
				$this->halt("Link-ID == false, pconnect failed");
			}

			if (!mysqli_query( $this->linkID, sprintf("use %s",$this->db))) {
				$this->halt("cannot use db ".$this->db);
			}

			mysqli_query($this->linkID, "SET NAMES 'utf8'");
		}
	}

	public function query($query_str) {
		$this->connect();
		$this->queryID = mysqli_query($this->linkID, $query_str);
		$this->row = 0;
		$this->errno = mysqli_errno( $this->linkID );
		$this->error = mysqli_error( $this->linkID );

		if(!$this->queryID) {
			$this->halt("SQL Syntax error. (".$query_str.")");
		}

		return $this;
	}

	public function fetch_all_rows() {
		while($tmp=$this->next_fetch_row()) {
			$tmp2[]=$tmp;
		}

		return $tmp2;
	}

	public function fetch_all_arrays() {
		while($tmp=$this->next_fetch_array()) {
			$tmp2[]=$tmp;
		}

		return $tmp2;
	}

	public function fetch_all_objects() {
		while($tmp=$this->next_fetch_object()) {
			$tmp2[]=$tmp;
		}

		return $tmp2;
	}

	public function result_array_all() {
		$tmp = Array();
		$i=0;

		while($data = $this->next_fetch_array()) {
			$tmp[$i++]=$data;
		}

		return $tmp;
	}

	public function next_fetch_array() {
		if(!$this->linkID) return false;

		$this->record = mysqli_fetch_array($this->queryID);
		$this->errno = mysqli_errno($this->linkID);
		$this->error = mysqli_error($this->linkID);
		$stat = is_array($this->record);

		if(!$stat) {
			mysqli_free_result($this->queryID);
			$this->queryID = 0;
		}

		return $this->record;
	}

	public function next_fetch_row() {
		if(!$this->linkID) return false;

		$this->record = @mysqli_fetch_row($this->queryID, $this->row++);
		$this->errno = mysqli_errno($this->linkID);
		$this->error = mysqli_error($this->linkID);
		$stat = is_array($this->record);

		if(!$stat) {
			mysqli_free_result($this->queryID);
			$this->queryID = 0;
		}

		return $this->record;
	}

	public function next_fetch_object() {
		if(!$this->linkID) return false;

		$this->record = @mysqli_fetch_object($this->queryID);
		$this->errno = mysqli_errno($this->linkID);
		$this->error = mysqli_error($this->linkID);
		$stat = is_object($this->record);

		if(!$stat) {
			mysqli_free_result($this->queryID);
			$this->queryID = 0;
		}

		return $this->record;
	}

	public function get_var($query_str) {
		$this->connect();
		$this->queryID = mysqli_query($this->linkID, $query_str);
		$this->record = mysqli_fetch_array($this->queryID);
		$this->row = 0;
		$this->errno = mysqli_errno($this->linkID);
		$this->error = mysqli_error($this->linkID);

		if(!$this->queryID) {
			$this->halt("SQL Syntax error. (".$query_str.")");
		}

		$stat = is_array($this->record);

		if(!$stat) {
			mysqli_free_result($this->queryID);
			$this->queryID = 0;
		}

		return $this->record[0];
	}

	public function get_vars($query_str) {
		$this->connect();
		$this->queryID = mysqli_query($this->linkID, $query_str);
		$this->record = mysqli_fetch_array($this->queryID);
		$this->row = 0;
		$this->errno = mysqli_errno($this->linkID);
		$this->error = mysqli_error($this->linkID);

		if(!$this->queryID) {
			$this->halt("SQL Syntax error. (".$query_str.")");
		}

		$stat = is_array($this->record);

		if(!$stat) {
			mysqli_free_result($this->queryID);
			$this->queryID = 0;
		}

		return $this->record;
	}

	public function affected_rows() {
		return mysqli_affected_rows($this->linkID);
	}

	public function num_rows() {
		return @mysqli_num_rows($this->queryID);
	}

	public function num_fields() {
		return mysqli_num_fields($this->queryID);
	}

	public function escape_string($query) {
		$this->connect();

		return mysqli_escape_string($this->linkID, $query);
	}

	public function insert_id() {
		return mysqli_insert_id($this->linkID);
	}

	public function autocommit() {
		$this->connect();

		return mysqli_autocommit($this->linkID, FALSE);
	}

	public function commit() {
		return mysqli_commit($this->linkID);
	}


	public function rollback() {
		return mysqli_rollback($this->linkID);
	}

	private function halt($msg) {
		if($_SERVER['REMOTE_ADDR'] == $this->debugAddr) {
			$call = $_SERVER['PHP_SELF'];
			echo "<pre>";
			echo "<b>DB error occurred.</b>\n";
			echo "<b>- msg : </b>".$msg."\n";
			echo "<b>- code : </b>".$this->errno." (".$this->error.")\n";
			echo "<b>- call : </b>".$call."\n";
			echo "</pre>";
			die("<pre>DB Close.</pre>");
		}
	}
}
?>
